/*
 * Decompiled with CFR 0.152.
 */
package tech.feldman.betterrecords.block;

import java.util.Collection;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;
import tech.feldman.betterrecords.api.sound.Sound;
import tech.feldman.betterrecords.api.wire.IRecordWire;
import tech.feldman.betterrecords.api.wire.IRecordWireManipulator;
import tech.feldman.betterrecords.block.ItemModelProvider;
import tech.feldman.betterrecords.block.ModBlock;
import tech.feldman.betterrecords.block.ModBlockDirectional;
import tech.feldman.betterrecords.block.TESRProvider;
import tech.feldman.betterrecords.block.tile.TileRadio;
import tech.feldman.betterrecords.client.render.RenderRadio;
import tech.feldman.betterrecords.helper.ConnectionHelper;
import tech.feldman.betterrecords.helper.nbt.SoundHolderHelperKt;
import tech.feldman.betterrecords.item.ModItems;
import tech.feldman.betterrecords.network.PacketHandler;
import tech.feldman.betterrecords.network.PacketRadioPlay;
import tech.feldman.betterrecords.network.PacketSoundStop;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0016JP\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#H\u0016J \u0010&\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010'\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001bH\u0016\u00a8\u0006)"}, d2={"Ltech/feldman/betterrecords/block/BlockRadio;", "Ltech/feldman/betterrecords/block/ModBlockDirectional;", "Ltech/feldman/betterrecords/block/TESRProvider;", "Ltech/feldman/betterrecords/block/tile/TileRadio;", "Ltech/feldman/betterrecords/block/ItemModelProvider;", "name", "", "(Ljava/lang/String;)V", "breakBlock", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "dropItem", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "kotlin.jvm.PlatformType", "block", "Lnet/minecraft/world/IBlockAccess;", "getRenderClass", "Lkotlin/reflect/KClass;", "Ltech/feldman/betterrecords/client/render/RenderRadio;", "getTileEntityClass", "onBlockActivated", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "side", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "onBlockAdded", "removedByPlayer", "willHarvest", "BetterRecords"})
public final class BlockRadio
extends ModBlockDirectional
implements TESRProvider<TileRadio>,
ItemModelProvider {
    @Override
    @NotNull
    public KClass<TileRadio> getTileEntityClass() {
        return Reflection.getOrCreateKotlinClass(TileRadio.class);
    }

    @Override
    @NotNull
    public KClass<RenderRadio> getRenderClass() {
        return Reflection.getOrCreateKotlinClass(RenderRadio.class);
    }

    public void func_176213_c(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        world.func_184138_a(pos, state, state, 3);
    }

    public AxisAlignedBB func_185496_a(@NotNull IBlockState state, @NotNull IBlockAccess block, @NotNull BlockPos pos) {
        AxisAlignedBB axisAlignedBB;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        switch (this.func_176201_c(state)) {
            case 0: 
            case 2: {
                axisAlignedBB = new AxisAlignedBB(0.13, 0.0, 0.2, 0.87, 0.98, 0.8);
                break;
            }
            case 1: 
            case 3: {
                axisAlignedBB = new AxisAlignedBB(0.2, 0.0, 0.13, 0.8, 0.98, 0.87);
                break;
            }
            default: {
                axisAlignedBB = Block.field_185505_j;
            }
        }
        return axisAlignedBB;
    }

    public boolean func_180639_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing side, float hitX, float hitY, float hitZ) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        ItemStack itemStack = player.func_184614_ca();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"player.heldItemMainhand");
        if (itemStack.func_77973_b() instanceof IRecordWireManipulator) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileRadio)) {
            tileEntity = null;
        }
        TileRadio tileRadio = (TileRadio)tileEntity;
        if (tileRadio != null) {
            TileRadio tileRadio2;
            TileRadio te = tileRadio2 = tileRadio;
            if (player.func_70093_af()) {
                te.setOpening(!te.getOpening());
                world.func_184138_a(pos, state, state, 3);
                world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.chest.close")), SoundCategory.NEUTRAL, 0.2f, world.field_73012_v.nextFloat() * 0.2f + 3.0f, false);
            } else if (te.getOpening()) {
                if (!te.getCrystal().func_190926_b()) {
                    if (!world.field_72995_K) {
                        this.dropItem(world, pos);
                    }
                    ItemStack itemStack2 = ItemStack.field_190927_a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"ItemStack.EMPTY");
                    te.setCrystal(itemStack2);
                    world.func_184138_a(pos, state, state, 3);
                } else {
                    ItemStack itemStack3 = player.func_184614_ca();
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"player.heldItemMainhand");
                    if (Intrinsics.areEqual((Object)itemStack3.func_77973_b(), (Object)((Object)ModItems.INSTANCE.getItemFrequencyCrystal()))) {
                        ItemStack itemStack4 = player.func_184614_ca();
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack4, (String)"player.heldItemMainhand");
                        Collection collection = SoundHolderHelperKt.getSounds(itemStack4);
                        if (!collection.isEmpty()) {
                            ItemStack itemStack5 = player.func_184614_ca();
                            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack5, (String)"player.heldItemMainhand");
                            te.setCrystal(itemStack5);
                            world.func_184138_a(pos, state, state, 3);
                            ItemStack itemStack6 = player.func_184614_ca();
                            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack6, (String)"player.heldItemMainhand");
                            int n = itemStack6.func_190916_E();
                            itemStack6.func_190920_e(n + -1);
                            if (!world.field_72995_K) {
                                WorldProvider worldProvider = world.field_73011_w;
                                Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
                                PacketHandler.INSTANCE.sendToAll(new PacketRadioPlay(pos, worldProvider.getDimension(), te.getSongRadius(), ((Sound)CollectionsKt.first(SoundHolderHelperKt.getSounds(te.getCrystal()))).getName(), ((Sound)CollectionsKt.first(SoundHolderHelperKt.getSounds(te.getCrystal()))).getUrl()));
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean removedByPlayer(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer player, boolean willHarvest) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            if (world.field_72995_K) break block2;
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof IRecordWire)) {
                tileEntity = null;
            }
            IRecordWire iRecordWire = (IRecordWire)tileEntity;
            if (iRecordWire != null) {
                IRecordWire iRecordWire2;
                IRecordWire te = iRecordWire2 = iRecordWire;
                ConnectionHelper.INSTANCE.clearConnections(world, te);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180663_b(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.dropItem(world, pos);
        super.func_180663_b(world, pos, state);
    }

    private final void dropItem(World world, BlockPos pos) {
        block3: {
            TileRadio tileRadio;
            TileRadio te;
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof TileRadio)) {
                tileEntity = null;
            }
            TileRadio tileRadio2 = (TileRadio)tileEntity;
            if (tileRadio2 == null || (te = (tileRadio = tileRadio2)).getCrystal().func_190926_b()) break block3;
            Random random = new Random();
            double rx = random.nextDouble() * (double)0.8f + (double)0.1f;
            double ry = random.nextDouble() * (double)0.8f + (double)0.1f;
            double rz = random.nextDouble() * (double)0.8f + (double)0.1f;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + rx, (double)pos.func_177956_o() + ry, (double)pos.func_177952_p() + rz, new ItemStack(te.getCrystal().func_77973_b(), te.getCrystal().func_190916_E(), te.getCrystal().func_77952_i()));
            if (te.getCrystal().func_77942_o()) {
                ItemStack itemStack = entityItem.func_92059_d();
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"entityItem.item");
                NBTTagCompound nBTTagCompound = te.getCrystal().func_77978_p();
                if (nBTTagCompound == null) {
                    Intrinsics.throwNpe();
                }
                itemStack.func_77982_d(nBTTagCompound.func_74737_b());
            }
            entityItem.field_70159_w = random.nextGaussian() * (double)0.05f;
            entityItem.field_70181_x = random.nextGaussian() * (double)0.05f + (double)0.2f;
            entityItem.field_70179_y = random.nextGaussian() * (double)0.05f;
            world.func_72838_d((Entity)entityItem);
            te.getCrystal().func_190920_e(0);
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
            te.setCrystal(itemStack);
            BlockPos blockPos = te.func_174877_v();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"te.pos");
            WorldProvider worldProvider = world.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
            PacketHandler.INSTANCE.sendToAll(new PacketSoundStop(blockPos, worldProvider.getDimension()));
        }
    }

    public BlockRadio(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Material material = Material.field_151575_d;
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"Material.WOOD");
        super(material, name);
        this.func_149711_c(2.0f);
        this.func_149752_b(6.3f);
    }

    @Override
    public void bindTESR() {
        TESRProvider.DefaultImpls.bindTESR(this);
    }

    @Override
    public void registerTESRItemStacks(@NotNull ModBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)block), (String)"block");
        TESRProvider.DefaultImpls.registerTESRItemStacks(this, block);
    }

    @Override
    public void registerTileEntity(@NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        TESRProvider.DefaultImpls.registerTileEntity(this, block);
    }

    @Override
    public void registerItemModel(@NotNull ModBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)block), (String)"block");
        ItemModelProvider.DefaultImpls.registerItemModel(this, block);
    }
}

